# Laravel Repository Artisan

## Installation

You can install the package via composer:

```bash
composer config repositories.gitlab.sib.swiss/309 '{"type": "composer", "url": "https://gitlab.sib.swiss/api/v4/group/309/-/packages/composer/packages.json"}'
composer require dterumal/laravel-repository-artisan:1.0.0 

```

## Usage

```php
php artisan make:interface --model=Foo FooInterface
```

This will create an interface `FooInterface` in `App/Contracts` directory using the `Foo` Eloquent model.

```php
php artisan make:repository --model=Foo --interface=FooInterface FooRepository
```

This will create a repository class `FooRepository` implementing `FooInterface` and using `Foo` Eloquent model.

**Note:** When using options such as `--model` or `--interface`, please note that if class/interface doesn't exist, the terminal will prompt you with a confirmation to automatically create it.

## Testing

```bash
composer test
```

## Changelog

Please see [CHANGELOG](CHANGELOG.md) for more information on what has changed recently.

## Contributing

Please see [CONTRIBUTING](.gitlab/CONTRIBUTING.md) for details.

## Security Vulnerabilities

Please review [our security policy](.gitlab/SECURITY.md) on how to report security vulnerabilities.

## Credits

- [Dillenn Terumalai](https://gitlab.sib.swiss/dterumal)

## License

The MIT License (MIT). Please see [License File](LICENSE.md) for more information.